local num_players = GAMESTATE:GetHumanPlayers();

local t = LoadFallbackB();

for i=1,#num_players do
	local metrics_name = "PlayerNameplate" .. ToEnumShortString(num_players[i])
	t[#t+1] = LoadActor( THEME:GetPathG(Var "LoadingScreen", "PlayerNameplate"), num_players[i] ) .. {
		InitCommand=function(self)
			self:name(metrics_name);
			ActorUtil.LoadAllCommandsAndSetXY(self,Var "LoadingScreen"); 
		end
	}
end

Def.Actor {
	AskForGoToOptionsCommand=function(self) self:sleep(2) end;
}

t[#t+1] = StandardDecorationFromFileOptional("SongOptions","SongOptionsText") .. {
	OnCommand=function(self) self:visible(false):draworder(1000):diffuse(color("#CBDDF0")):shadowlength(1):skewx(-0.2) end;
	AskForGoToOptionsCommand=function(self)
		self:visible(true):diffusealpha(0):addy(-6)
		:settext(ToUpper(THEME:GetString("ScreenSelectMusic","Press Start For Options"))):decelerate(0.3):addy(6):diffusealpha(1)
		:sleep(1.0):linear(0.3):diffusealpha(0)
	end;
	GoToOptionsCommand=THEME:GetMetric(Var "LoadingScreen","SongOptionsEnterCommand");
	HidePressStartForOptionsCommand=THEME:GetMetric(Var "LoadingScreen","SongOptionsHideCommand");
};

return t;